package jp.mosp.common.part;

import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;

import jp.mosp.workflow.dao.AmRouteDao;
import jp.mosp.workflow.dao.AmUnitDao;
import jp.mosp.workflow.dto.AmUnitDto;

/**
 * FpPartNX
 * @author yoshida
 *	@version	0.0.2
 */
public class ApprovalPart extends BasePart {

	/**
	 * RXgN^
	 */
	public ApprovalPart() {
		super();
	}

	/**
	 * RXgN^
	 * @param partInfo
	 */
	public ApprovalPart(PartInfo partInfo) {
		super(partInfo);
	}

	/**
	 * Fpjbge[upDAO擾
	 * @return	ςAmUnitDaoCX^X
	 * @throws Exception
	 */
	public AmUnitDao getAmUnitDao() throws Exception {
		return (AmUnitDao) getPreparedDao(AmUnitDao.class.getCanonicalName());
	}

	/**
	 * Fp[ge[upDAO擾
	 * @return	ςAmRouteDaoCX^X
	 * @throws Exception
	 */
	public AmRouteDao getAmRouteDao() throws Exception {
		return (AmRouteDao) getPreparedDao(AmRouteDao.class.getCanonicalName());
	}

	/**
	 * 󏳔FjbgR[hꗗiAM_UNITj
	 * @return@̏FjbgR[hXg
	 * @throws Exception
	 */
	public String[][] getCurrentUnitArray() throws Exception {
		String targetDate = DatePart.convDateFormattedByHyphen(DatePart.getSystemDate());
		// ̎擾
		List<AmUnitDto> listUnit = getAmUnitDao().findForCurrentUnitArray(targetDate);
		// z̍쐬		
		String[][] aryUnitList = new String[listUnit.size()][2];
		for (int i = 0; i < listUnit.size(); i++) {
			aryUnitList[i][0] = listUnit.get(i).getUnitCode();
			StringBuffer sb = new StringBuffer();
			sb.append(human().getKName(listUnit.get(i).getMain()));
			sb.append(CommonConst.STR_SLASH_SEPARATOR);
			sb.append(human().getKName(listUnit.get(i).getAgent()));
			aryUnitList[i][1] = sb.toString();
		}
		return aryUnitList;
	}

	/**
	 * Ώ۔NFjbg擾
	 * @since	0.0.2
	 * @param unitCode		ΏۃjbgR[h
	 * @param kCode			ΏێЈR[h
	 * @param startDate		ΏۊJnN
	 * @return	Ώ۔NFjbgDTO
	 * @throws Exception
	 */
	public AmUnitDto getCurrentUnit(
			String unitCode,
			String kCode,
			String startDate
	) throws Exception {
		return getAmUnitDao().findForCurrentUnit(unitCode, kCode, startDate);
	}

	/**
	 * Ώ۔NΏۃjbgR[hFҔf
	 * @since	0.0.2
	 * @param unitcode		ΏۃjbgR[h
	 * @param targetDate	Ώ۔N
	 * @return
	 * <p>
	 * Ώ۔NFjbgDTOꍇtrueAłȂꍇfalse
	 * </p>
	 * @throws Exception
	 */
	public boolean isApprover(String unitcode, Date targetDate) throws Exception {
		return VariousPart.chkExistDto(getCurrentUnit(
				unitcode,
				human().getBasisInfoOfUser().getKCode(),
				DatePart.convDateFormattedByHyphen(targetDate))
		);
	}

}
